AppTitle "RPG 2D scrolling multi map - cursor keys to move."
Graphics 640,480,16,2
SetBuffer BackBuffer()

Global editmode = False
Global edittile 

Global keys = 0
Global gold = 0

; map variables
Global mw = 40
Global mh = 30
Global tw = 32
Global th = 32

Global numlevels = 5

Dim map(numlevels,mw,mh)
; player variables
Global pw = (tw-5)
Global ph = (th-5)
Global px = GraphicsWidth()/2-tw/2
Global py = GraphicsHeight()/2-th/2
; scrolling variables
Global mx
Global my
Global msx=0
Global msy

; for the multi map
;
; this is a mdimensional array
; the player location on the multi map
; is mcx (map cursor x)
; it starts at 1,1, the center of the 
; multidimensional array
;
Global mcx=1
Global mcy=1
Dim ml(3,3)
;corner maps -1 non existant
ml(0,0)=-1
ml(2,0)=-1
ml(0,2)=-1
ml(2,2)=-1
; the maps assigned
ml(1,0)=1
ml(1,1)=0
ml(2,1)=2
ml(1,2)=3
ml(0,1)=4

; Here we create/buffer the maps
Dim mapimage(5)
For i=0 To 5
	mapimage(i) = CreateImage(mw*tw,mh*th)
Next
Text 0,0,"Please wait"
Flip

readlevels()
makemaps()

.mainloop
While KeyDown(1) = False
	Cls	
	If KeyHit(18);key e
		If editmode=True Then editmode = False Else editmode = True
	EndIf
	edit
	If editmode = False
		For i=0 To 4 ;speed of movement
			moveplayer
			playeritemcollision
			centermap
			switchmap()
		Next
		DrawBlock mapimage(ml(mcx,mcy)),msx,msy
		drawplayer	
		Color 255,255,255
		Text 0,0,"Use cursors to move around"
		Text 0,15,"cursor : " + mcx +","+mcy+" on map : "+ml(mcx,mcy)
		Text 320,0,"gold:"+gold+" keys:"+keys
		Text 320,15,"Press e for edit mode"
	End If
	Flip
Wend
End


Function edit()
	If editmode = True
		DrawBlock mapimage(ml(mcx,mcy)),msx,msy
		Color 20,20,20		
		Rect 0,0,GraphicsWidth(),36,True
		For x=0 To 10
			drawtile(x,0,x)
			If edittile = x
				Color 255,0,0
				Rect x*tw,y*th,32,32,False
			End If
			If RectsOverlap(MouseX(),MouseY(),1,1,x*tw,0,32,32)
				Color 255,255,255
				Rect x*tw,0,32,32,False
				Color 0,0,0
				Rect x*tw+1,1,30,30,False
				If MouseDown(1) = True
					edittile = x
				End If
			End If
		Next
		If RectsOverlap(MouseX(),MouseY(),1,1,0,32,GraphicsWidth(),GraphicsHeight()-32)
			x1 = (MouseX()-msx)/tw
			y1 = (MouseY()-msy)/th
			If MouseDown(1) = True
				map(ml(mcx,mcy),x1,y1)=edittile
				updatemap x1,y1,edittile
			End If
			Color 255,255,255
			Rect x1*tw,y1*th,32,32,False
			Color 0,0,0
			Rect x1*tw+1,y1*th+1,30,30,False
		End If
		If KeyDown(205) ; right
			msx=msx-3
		EndIf
		If KeyDown(203);left		
			msx=msx+3
		End If
		If KeyDown(200);up
			msy=msy+3
		End If
		If KeyDown(208);down
			msy=msy-3
		End If
	End If
End Function

; here we check if the player is
; at a border and if he can go to another map
; and set the start positions
Function switchmap()
	; touches the left side of the screen
	If px<5 And mcx>0 
		If ml(mcx-1,mcy) <>-1
			mcx=mcx-1
			px=630-pw			
			msx=-(mw*tw-GraphicsWidth())
			If py<10 Then py=py+10
			If py+ph>GraphicsHeight()-10 Then py=py-10
		End If		
	End If
	; touches the top part of the screen
	If py<5 And mcy>0 
		If ml(mcx,mcy-1) <> -1
			mcy=mcy-1
			py=470-ph
			msy=-(mh*th-GraphicsHeight())
			If px<10 Then px=10
			If px+pw>GraphicsWidth()-10 Then px=px-10
		End If
	End If
	; touches the right side of the screen
	If px+pw>GraphicsWidth()-4 And mcx<2
		If ml(mcx+1,mcy) <> -1
			mcx=mcx+1
			px=10
			msx=0
			If py<10 Then py=10
			If py+ph>GraphicsHeight()-10 Then py=py-10
		End If
	End If
	; touches the bottom of the screen
	If py+ph>GraphicsHeight()-5 And mcy<2
		If ml(mcx,mcy+1) <>-1
			mcy=mcy+1
			py=10
			msy=0
			If px<10 Then px=px+10
			If px+pw>GraphicsWidth()-10 Then px=px-10
		End If
	End If
End Function

Function centermap()
	If px<GraphicsWidth()/3 And Abs(msx)>0 Then msx=msx+1 :px=px+1
	If py<GraphicsHeight()/3 And Abs(msy)>0 Then msy=msy+1 :py=py+1
	If px>GraphicsWidth()/100*66
		If (Abs(msx)+GraphicsWidth()) < mw*tw
			msx=msx-1
			px=px-1
		End If
	End If
	If py>GraphicsHeight()/100*66
		If (Abs(msy)+GraphicsHeight()) < mh*th
			msy=msy-1
			py=py-1
		End If
	End If	
End Function

Function moveplayer()
	Local x=0
	Local y=0
	If KeyDown(200) ; up
		y=-1
	End If
	If KeyDown(205) ; right
		x=1
	End If
	If KeyDown(208) ; down
		y=1
	End If
	If KeyDown(203) ; left
		x=-1
	End If
	If px+x < 0 Then x=0
	If px+pw+x > GraphicsWidth() Then x=0
	If py+y < 0 Then y=0
	If py+ph+y > GraphicsHeight() Then y=0
	If playermapcollision((px+Abs(msx))+x,py+Abs(msy)) = False
		px=px+x
	End If
	If playermapcollision(px+Abs(msx),py+Abs(msy)+y) = False
		py=py+y
	End If

End Function

Function playermapcollision(x1,y1)
	Local cx=x1/tw
	Local cy=y1/th
	For y2=cy-1 To cy+1
	For x2=cx-1 To cx+1	
		If x2>=0 And x2<=mw And y2>=0 And y2<=mh
		mt = map(ml(mcx,mcy),x2,y2)
		If mt >= 1 And mt <= 3 Or mt = 7 ; is the map around the player a block
		If RectsOverlap(x2*tw,y2*th,tw,th,x1,y1,pw,ph)
			;
			; Here the player is inside a wall
			; a value 1 on the map
			;
			Return True
			;
		End If
		End If
		End If
	Next
	Next
	; no collision occured
	Return False
End Function

Function playeritemcollision()
	Local cx=(px+Abs(msx))/tw
	Local cy=(py+Abs(msy))/th
	For y2=cy-1 To cy+1
	For x2=cx-1 To cx+1
		If x2>=0 And x2<=mw And y2>=0 And y2<=mh
		; collision with coin
		If map(ml(mcx,mcy),x2,y2) = 9 ; is the map around the player a 9 value
		If RectsOverlap(x2*tw+8,y2*th+8,tw-16,th-16,px+Abs(msx),py+Abs(msy),pw,ph)
			;
			; Here the player touches a map item (9)
			; We remove it from the map
			;
			gold=gold+1
			map(ml(mcx,mcy),x2,y2) = 0
			updatemap(x2,y2,0)
		End If
		End If
		; collision with key
		If map(ml(mcx,mcy),x2,y2) = 8 ; is the map around the player a 9 value
		If RectsOverlap(x2*tw+8,y2*th+8,tw-16,th-16,px+Abs(msx),py+Abs(msy),pw,ph)
			;
			; Here the player touches a map item (9)
			; We remove it from the map
			;
			keys=keys+1
			map(ml(mcx,mcy),x2,y2) = 0
			updatemap(x2,y2,0)
		End If
		End If
		; collision with door
		If map(ml(mcx,mcy),x2,y2) = 7 ; is the map around the player a 9 value
		If RectsOverlap(x2*tw-1,y2*th-1,tw+2,th+2,px+Abs(msx),py+Abs(msy),pw,ph)
		If keys>0
			;
			; Here the player touches a map item (9)
			; We remove it from the map
			;
			keys=keys-1
			map(ml(mcx,mcy),x2,y2) = 0
			updatemap(x2,y2,0)
		End If
		End If
		End If


		End If
	Next
	Next
End Function


Function updatemap(x,y,t)
	SetBuffer ImageBuffer(mapimage(ml(mcx,mcy)))
	drawtile(x,y,t)
	SetBuffer BackBuffer()
End Function

Function drawplayer()
	Color 0,0,255
	Oval px,py,pw,ph
End Function

Function makemaps()
	For i=0 To numlevels
	SetBuffer ImageBuffer(mapimage(i))
	For y=0 To mh-1
	For x=0 To mw-1
		a = map(i,x,y)
		drawtile(x,y,a)
	Next
	Next
	Next
	SetBuffer BackBuffer()
End Function

Function drawtile(x,y,t)
	Select t
		Case 0;nothing
			Color 0,0,0
			Rect x*tw,y*th,tw,th
		Case 1;wall
			Color 255,255,255
			Rect x*tw,y*th,tw,th,True
		Case 2;water
			Color 30,80,255
			Rect x*tw,y*th,tw,th,True
		Case 3;tree
			Color 0,255,0
			x1=x*tw
			y1=y*th
			Line x1+tw/2,y1,x1+tw,y1+th
			Line x1+tw,y1+th-1,x1,y1+th-1
			Line x1,y1+th,x1+tw/2,y1
		Case 7 ; door
			Color 150,150,150
			Rect x*tw,y*th,tw,th
		Case 8; key
			Color 200,200,0
			Oval x*tw+2,y*th+2,tw-4,th-4
			Color 255,255,255
			Text x*tw+tw/2,y*th+th/2,"K",1,1			
		Case 9 ; gold
			Color 200,200,0
			Oval x*tw+2,y*th+2,tw-4,th-4
	End Select
End Function

Function readlevels()
	Restore level1
	For i=0 To numlevels-1
		For y=0 To mh-1
		For x=0 To mw-1
			Read a
			map(i,x,y) = a
		Next
		Next
	Next
End Function

.level1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,8,0,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,1,0,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,1,0,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1
Data 0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,3,0,0,0,1,1,1,1
Data 0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0
Data 0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0
Data 0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0
Data 0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,9,9,9,1,0,0,0,0,3,3,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0
Data 0,0,0,1,0,0,0,9,9,1,0,0,0,0,1,9,9,9,1,0,0,0,0,3,3,3,0,0,0,0,3,3,3,3,3,0,0,0,0,0
Data 0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,1,0,0,0,0,0,1,0,0,1,1,1,1,1,7,1,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,1,0,0,0,0,0,7,0,0,7,0,0,0,0,0,1,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0
Data 0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,8,2,2,2,2,2,2,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,2,2,0,0,0,0,0,0,3,3,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3
Data 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3
Data 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3
.level2
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1
Data 0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1
Data 0,0,1,0,9,9,1,0,0,0,3,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1
Data 0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1
Data 0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1
Data 0,0,1,1,7,1,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,3,0,0,0,0,0,0,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0
Data 0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,2,2,2,2,2,0,0,0,0,0,3,3,3,0,0,0
Data 0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,3,3,0,0
Data 0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,2,0,0,0,0,0,0,3,0,0
Data 0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0
Data 0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0
Data 0,2,2,2,2,8,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0
Data 2,2,2,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0
Data 2,2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0
Data 2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
Data 0,0,0,3,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1
Data 0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,1,1,1,1,1
Data 0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1
.level3
Data 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
Data 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
Data 3,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,3,3,3
Data 3,3,3,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,3,3,3,0,3,3,3,0,3,3,0,0,0,0,0,0,0,3,3,3
Data 3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,3,3,3
Data 3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,3,3,3
Data 3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,3,3,3
Data 3,8,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,3,3,3
Data 3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,3
Data 3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,3,3
Data 0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,1,1,1,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,9,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,3
Data 0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,3
Data 0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3
Data 0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 3,3,3,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3
Data 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
.level4
Data 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3
Data 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3
Data 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3
Data 3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3
Data 3,0,0,1,1,1,7,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3
Data 3,0,0,1,9,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,1,1,1,1,0,0,3
Data 3,0,0,1,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,9,1,0,0,3
Data 3,0,0,1,0,0,0,1,1,1,1,1,1,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,9,1,0,0,3
Data 3,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,3
Data 3,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,3
Data 3,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,1,1,1,1,0,0,3
Data 3,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 3,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3
Data 3,0,0,7,0,0,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3
Data 3,0,0,1,0,0,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3
Data 3,0,0,1,0,9,1,0,0,0,3,3,3,3,3,3,3,8,0,0,0,3,3,3,0,3,0,0,0,0,0,0,3,3,3,3,3,3,3,3
Data 3,0,0,1,1,1,1,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,3,3,8,3,3,3,3,3
Data 3,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,3,3,3,3,3
Data 3,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,3,3,3,3,3
Data 3,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,0,0,0,0,0,0,0,3,0,3,3
Data 3,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,3,3
Data 3,3,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3
Data 3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3
Data 3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3
Data 3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3
Data 3,3,3,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2
Data 3,3,3,0,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
Data 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
.level5
Data 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0
Data 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0
Data 3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0
Data 3,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0
Data 3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0
Data 3,3,3,3,3,3,0,3,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0
Data 3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,0,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,0,0,0,0,1,1,1,0,0,0,0,0,3,0,0,0,0,7,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,0,0,0,0,7,0,1,0,0,0,0,3,0,0,0,0,0,1,0,0,0,0,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,0,0,0,0,1,9,1,0,0,0,0,3,0,0,0,0,0,1,0,0,0,0,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,9,9,8,8,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0
Data 2,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 2,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 2,2,3,3,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Data 2,2,2,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0
Data 2,2,2,3,3,3,0,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0
Data 2,2,2,3,3,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0
Data 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,0,0,3,3,0,0,3,3,3,3,0,0,0,0,0,0,0,0
Data 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0
Data 2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0
Data 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
Data 2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
